;******************************************************************  
;That can't be modified by user.
;******************************************************************  
IFNDEF	_BC66F019_MCU_INC_

#DEFINE	_BC66F019_MCU_INC_

;------------------------------------------------------------------        
INCLUDE	ht66f019.inc

;------------------------------------------------------------------        
SCK_DIR		EQU	PBC6
SCK_PORT	EQU	PB6
SDA_DIR		EQU	PAC3
SDA_PORT	EQU	PA3

;------------------------------------------------------------------
; define the timer and data out port of RF
;------------------------------------------------------------------
RX_TMF		EQU	STMAF		;set RF timer overflow flag
RFDATA		EQU	SDA_PORT

;------------------------------------------------------------------        
InitRxTM  	MACRO
            MOV		A,00h		    	;fSYS/4=2MHz
            MOV		STMC0,A        		;
            MOV		A,0C1h		    	;Timer/Counter, CCRA
            MOV		STMC1,A        		;
            			
            MOV		A,LOW RF_RX_CNT		;update time counter
			MOV		STMAL,A
            MOV		A,HIGH RF_RX_CNT
			MOV		STMAH,A	
				
			SET		MF0E					
         	SET		STMAE
ENDM 
 
;------------------------------------------------------------------        
RFTimerOn	MACRO
           	SET     STON		
ENDM            

;------------------------------------------------------------------        
RFTimerOff	MACRO
           	CLR     STON		
ENDM            

ENDIF
